<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use App\Models\Configuration;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Add privacy policy configuration
        Configuration::updateOrCreate(
            ['key' => 'privacy_policy'],
            [
                'value' => $this->getDefaultPrivacyPolicy(),
                'description' => 'Privacy Policy content (HTML allowed)',
                'type' => 'textarea',
                'group' => 'legal'
            ]
        );

        // Also update ToS configuration if it doesn't exist
        Configuration::updateOrCreate(
            ['key' => 'store_terms_of_service'],
            [
                'value' => Configuration::where('key', 'store_terms_of_service')->value('value') ?? $this->getDefaultToS(),
                'description' => 'Terms of Service content (HTML allowed)',
                'type' => 'textarea',
                'group' => 'legal'
            ]
        );
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Configuration::where('key', 'privacy_policy')->delete();
    }

    /**
     * Get default privacy policy content
     */
    private function getDefaultPrivacyPolicy(): string
    {
        return <<<'HTML'
<h2>1. Introduction</h2>
<p>Welcome to our gaming community. We respect your privacy and are committed to protecting your personal data. This privacy policy explains how we collect, use, and safeguard your information when you use our website and services.</p>

<h2>2. Information We Collect</h2>

<h3>2.1 Account Information</h3>
<p>When you create an account via Steam authentication, we automatically collect:</p>
<ul>
    <li><strong>Steam Username:</strong> Your public Steam display name</li>
    <li><strong>SteamID64:</strong> Your unique Steam identifier</li>
    <li><strong>Avatar:</strong> Your Steam profile picture</li>
</ul>
<p>This information is provided directly by Steam and is necessary for account creation and authentication.</p>

<h3>2.2 Forum Activity</h3>
<p>When you participate in our forums, we collect and store:</p>
<ul>
    <li>Thread titles and content you create</li>
    <li>Post replies and comments</li>
    <li>Reactions (likes, dislikes, etc.) you give to posts</li>
    <li>Timestamps of your forum activity</li>
</ul>

<h3>2.3 Store and Transaction Data</h3>
<p>When you make purchases through our store, we collect:</p>
<ul>
    <li><strong>Transaction Information:</strong> Package purchased, server selected, amounts (original, discounted, final), coupon usage</li>
    <li><strong>Payment Method:</strong> Whether you used PayPal or Stripe (we do NOT store credit card numbers)</li>
    <li><strong>IP Address:</strong> Recorded for fraud prevention and security purposes</li>
    <li><strong>PayPal Data:</strong> Order ID, transaction ID, and payment status information from PayPal</li>
    <li><strong>Stripe Data:</strong> Session ID, payment intent ID, and transaction status from Stripe</li>
</ul>
<p><em>Note: We do not store your full credit card information. Payment processing is handled securely by PayPal and Stripe, who maintain their own privacy policies.</em></p>

<h3>2.4 Technical Information</h3>
<p>We automatically collect certain technical information when you visit our website:</p>
<ul>
    <li>Browser type and version</li>
    <li>Operating system</li>
    <li>IP address</li>
    <li>Page views and navigation patterns</li>
    <li>Session duration</li>
</ul>

<h2>3. How We Use Your Information</h2>
<p>We use the collected information for the following purposes:</p>
<ul>
    <li><strong>Account Management:</strong> To create and maintain your account</li>
    <li><strong>Service Delivery:</strong> To provide purchased items and services in-game</li>
    <li><strong>Community Features:</strong> To enable forum participation and user profiles</li>
    <li><strong>Transaction Processing:</strong> To process and fulfill store purchases</li>
    <li><strong>Security:</strong> To detect and prevent fraud, abuse, and security threats</li>
    <li><strong>Communication:</strong> To send important updates about your account or services</li>
    <li><strong>Service Improvement:</strong> To analyze usage patterns and improve our services</li>
</ul>

<h2>4. Data Sharing and Disclosure</h2>
<p>We do not sell your personal information. We may share your data only in the following circumstances:</p>
<ul>
    <li><strong>Payment Processors:</strong> PayPal and Stripe receive necessary transaction information to process payments</li>
    <li><strong>Game Servers:</strong> Purchase information is transmitted to our game servers to deliver in-game items</li>
    <li><strong>Legal Requirements:</strong> When required by law, court order, or governmental authority</li>
    <li><strong>Business Transfer:</strong> In the event of a merger, acquisition, or sale of assets</li>
</ul>

<h2>5. Data Retention</h2>
<p>We retain your information for as long as necessary to provide our services and comply with legal obligations:</p>
<ul>
    <li><strong>Account Data:</strong> Retained while your account is active</li>
    <li><strong>Forum Posts:</strong> Retained indefinitely unless you delete them or request removal</li>
    <li><strong>Transaction Records:</strong> Retained for 7 years for tax and legal compliance</li>
    <li><strong>Technical Logs:</strong> Typically retained for 90 days</li>
</ul>

<h2>6. Your Rights</h2>
<p>You have the following rights regarding your personal data:</p>
<ul>
    <li><strong>Access:</strong> Request a copy of your personal data</li>
    <li><strong>Correction:</strong> Update or correct inaccurate information</li>
    <li><strong>Deletion:</strong> Request deletion of your account and associated data</li>
    <li><strong>Data Portability:</strong> Request your data in a portable format</li>
    <li><strong>Withdraw Consent:</strong> Opt-out of non-essential data processing</li>
</ul>
<p>To exercise these rights, please contact us using the information provided below.</p>

<h2>7. Cookies and Tracking</h2>
<p>We use cookies and similar technologies to:</p>
<ul>
    <li>Maintain your login session</li>
    <li>Remember your preferences</li>
    <li>Analyze site traffic and usage</li>
    <li>Prevent fraud and improve security</li>
</ul>
<p>You can control cookies through your browser settings, though some features may not function properly if cookies are disabled.</p>

<h2>8. Security</h2>
<p>We implement appropriate technical and organizational measures to protect your personal data, including:</p>
<ul>
    <li>Encrypted data transmission (HTTPS/SSL)</li>
    <li>Secure password hashing</li>
    <li>Regular security audits</li>
    <li>Access controls and authentication</li>
    <li>Secure payment processing through PCI-DSS compliant providers</li>
</ul>

<h2>9. Third-Party Services</h2>
<p>Our service integrates with the following third-party platforms:</p>
<ul>
    <li><strong>Steam:</strong> For authentication and account information (<a href="https://store.steampowered.com/privacy_agreement/" target="_blank">Steam Privacy Policy</a>)</li>
    <li><strong>PayPal:</strong> For payment processing (<a href="https://www.paypal.com/privacy" target="_blank">PayPal Privacy Policy</a>)</li>
    <li><strong>Stripe:</strong> For payment processing (<a href="https://stripe.com/privacy" target="_blank">Stripe Privacy Policy</a>)</li>
</ul>
<p>These services have their own privacy policies, and we recommend reviewing them.</p>

<h2>10. Children's Privacy</h2>
<p>Our services are not intended for children under 13 years of age. We do not knowingly collect personal information from children. If you believe we have collected information from a child, please contact us immediately.</p>

<h2>11. International Data Transfers</h2>
<p>Your data may be transferred to and processed in countries other than your country of residence. We ensure appropriate safeguards are in place to protect your data in accordance with applicable laws.</p>

<h2>12. Changes to This Policy</h2>
<p>We may update this privacy policy from time to time. We will notify you of significant changes by posting a notice on our website or sending you an email. Your continued use of our services after changes constitutes acceptance of the updated policy.</p>

<h2>13. Contact Information</h2>
<p>If you have questions about this privacy policy or wish to exercise your rights, please contact us:</p>
<ul>
    <li><strong>Website:</strong> [Your Website URL]</li>
    <li><strong>Email:</strong> [Your Contact Email]</li>
</ul>

<h2>14. Legal Basis for Processing (GDPR)</h2>
<p>For users in the European Economic Area, we process your data based on:</p>
<ul>
    <li><strong>Contractual Necessity:</strong> To provide the services you've requested</li>
    <li><strong>Legitimate Interests:</strong> To improve our services and prevent fraud</li>
    <li><strong>Legal Obligation:</strong> To comply with applicable laws</li>
    <li><strong>Consent:</strong> Where you've given explicit consent for specific purposes</li>
</ul>

<p><em>Last Updated: January 2024</em></p>
HTML;
    }

    /**
     * Get default Terms of Service content
     */
    private function getDefaultToS(): string
    {
        return <<<'HTML'
<h2>1. Agreement to Terms</h2>
<p>By accessing and using our gaming community services, you agree to be bound by these Terms of Service.</p>

<h2>2. Use of Services</h2>
<p>You agree to use our services in accordance with all applicable laws and regulations.</p>

<h2>3. Purchases and Refunds</h2>
<p>All purchases made through our store are final. Virtual goods are delivered immediately upon successful payment.</p>

<h2>4. User Conduct</h2>
<p>You agree not to engage in harassment, cheating, or any behavior that disrupts the community.</p>

<h2>5. Termination</h2>
<p>We reserve the right to terminate accounts that violate these terms without refund.</p>

<p><em>Last Updated: January 2024</em></p>
HTML;
    }
};